SET SQL_MODE="NO_AUTO_VALUE_ON_ZERO";

/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!40101 SET NAMES utf8 */;


CREATE TABLE `accountedrule` (
  `SubMenuID` varchar(50) NOT NULL default '',
  `Amount` double(15,2) NOT NULL default '0.00',
  `RuleLimit` double(15,2) NOT NULL default '0.00',
  `RuleNo` smallint(6) NOT NULL default '0',
  PRIMARY KEY  (`SubMenuID`,`RuleNo`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

CREATE TABLE `buffetconfig` (
  `id` int(10) unsigned NOT NULL auto_increment,
  `name` varchar(100) NOT NULL default '',
  `configkey` varchar(100) NOT NULL default '',
  `configvalue` varchar(100) NOT NULL default '',
  `configfunction` varchar(100) NOT NULL default '',
  `configgroup` varchar(100) NOT NULL default '',
  `description` varchar(255) NOT NULL default '',
  `custom1` varchar(100) NOT NULL default '',
  `custom2` varchar(100) NOT NULL default '',
  `custom3` varchar(100) NOT NULL default '',
  `changedate` datetime default NULL,
  `beforetype` varchar(50) default NULL,
  `tag1` tinyint(1) NOT NULL default '0',
  PRIMARY KEY  (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 AUTO_INCREMENT=41 ;

CREATE TABLE `buffetdish` (
  `id` int(10) unsigned NOT NULL auto_increment,
  `dishname` varchar(45) default NULL,
  `vipgroupuserid` varchar(45) default NULL,
  `submenuid` varchar(45) default NULL COMMENT 'selected value',
  `dishno` int(10) unsigned default NULL,
  `submenuid2` varchar(45) default NULL COMMENT 'unselected value',
  `dishpricetypeid` int(10) unsigned default NULL,
  PRIMARY KEY  (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 AUTO_INCREMENT=801 ;

CREATE TABLE `cashierloginfo` (
  `logid` int(11) NOT NULL auto_increment,
  `invoiceid` int(11) NOT NULL default '0',
  `orderid` int(11) default NULL,
  `cashierid` int(11) default NULL,
  `staffid` int(11) NOT NULL default '0',
  `logtime` timestamp NOT NULL default CURRENT_TIMESTAMP on update CURRENT_TIMESTAMP,
  `attribute1` varchar(45) default NULL,
  `attribute2` varchar(45) default NULL,
  `paymentstatus` tinyint(1) NOT NULL default '0',
  `roleid` int(11) default NULL,
  PRIMARY KEY  (`logid`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 AUTO_INCREMENT=11 ;

CREATE TABLE `cashieropeninfo` (
  `OrderID` int(10) NOT NULL default '0',
  `Timstamp` timestamp NOT NULL default CURRENT_TIMESTAMP on update CURRENT_TIMESTAMP,
  `WaiterID` int(10) default NULL,
  `PaidAmount` double(15,5) NOT NULL default '0.00000',
  `ChangeAmount` double(15,5) default NULL,
  `CashierID` int(10) default NULL,
  PRIMARY KEY  (`OrderID`,`Timstamp`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

CREATE TABLE `cashiermanlog` (
  `ID` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `cashierWaiterID` int(10) unsigned DEFAULT NULL,
  `ManConfirmTime` datetime DEFAULT NULL,
  `AmountSale` decimal(19,4) DEFAULT NULL,
  `AmountGiftcard` decimal(19,4) DEFAULT NULL,
  `AmountGiftcardRef` decimal(19,4) DEFAULT NULL,
  `AmountPayout` decimal(19,4) DEFAULT NULL,
  `AmountPost` decimal(19,4) DEFAULT NULL,
  PRIMARY KEY (`ID`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8;

CREATE TABLE `cashpayout` (
  `PayOutID` int(10) NOT NULL default '0',
  `TimStamp` timestamp NOT NULL default CURRENT_TIMESTAMP,
  `CategoryID` int(10) default NULL,
  `Details` varchar(200) default NULL,
  `PayTo` varchar(50) default NULL,
  `WaiterID` int(10) default NULL,
  `Amount` double NOT NULL default '0',
  `Void` tinyint(1) NOT NULL default '0',
  `cashierID` int(10) default NULL,
  `ManConfirm` tinyint(1) NOT NULL default '0',
  `cashierWaiterID` int(10) default NULL,
  PRIMARY KEY  (`PayOutID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

CREATE TABLE `comboinfo` (
  `ID` int(10) NOT NULL auto_increment,
  `MenuID` varchar(50) default NULL,
  `CategoryID` int(10) default NULL,
  `ItemCount` int(10) default NULL,
  `SectionId` int(10) default NULL,
  PRIMARY KEY  (`ID`),
  KEY `CategoryID` (`CategoryID`),
  KEY `ID` (`ID`),
  KEY `MenuID` (`MenuID`),
  KEY `SectionId` (`SectionId`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

CREATE TABLE `comboinfo-org` (
  `ID` int(10) NOT NULL,
  `MenuID` varchar(50) default NULL,
  `CategoryID` int(10) default NULL,
  `ItemCount` int(10) default NULL,
  `SectionId` int(10) default NULL,
  PRIMARY KEY  (`ID`),
  KEY `CategoryID` (`CategoryID`),
  KEY `ID` (`ID`),
  KEY `MenuID` (`MenuID`),
  KEY `SectionId` (`SectionId`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

CREATE TABLE `coupon` (
  `coupon_id` int(11) NOT NULL auto_increment,
  `coupon_code` varchar(64) NOT NULL,
  `name` varchar(64) default NULL,
  `description` varchar(128) default NULL,
  `max_use` int(11) NOT NULL default '1',
  `times_used` int(11) NOT NULL default '0',
  `custom1` varchar(128) default NULL,
  `custom2` varchar(128) default NULL,
  `custom3` varchar(128) default NULL,
  `custom4` varchar(128) default NULL,
  `custom5` varchar(128) default NULL,
  `date_added` datetime default NULL,
  `last_modified` datetime default NULL,
  `expiredate` datetime default NULL,
  `active` int(1) NOT NULL default '0',
  PRIMARY KEY  (`coupon_id`,`coupon_code`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 AUTO_INCREMENT=2 ;

CREATE TABLE `coupondetails` (
  `couponID` varchar(50) NOT NULL default '',
  `orderid` int(10) NOT NULL default '0',
  PRIMARY KEY  (`couponID`,`orderid`),
  KEY `couponID` (`couponID`),
  KEY `orderid` (`orderid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

CREATE TABLE `creditgifttrans` (
  `ID` int(12) unsigned NOT NULL default '0',
  `CC_Number` varchar(50) default NULL,
  `respind` tinyint(1) unsigned default NULL,
  `AuthCode` varchar(10) default NULL,
  `Amount` float(9,2) default NULL,
  `RefNum` varchar(10) default NULL,
  `AvsResltSect1` varchar(16) default NULL,
  `AvsResltSect2` varchar(16) default NULL,
  `AvsResltSect3` varchar(16) default NULL,
  `TimStamp` timestamp NOT NULL default CURRENT_TIMESTAMP on update CURRENT_TIMESTAMP,
  `CvvRefCode` varchar(1) default NULL,
  `Batchnum` varchar(6) default NULL,
  `TranCode` varchar(3) default NULL,
  `Sequence` int(12) default NULL,
  `AvsResltCode` varchar(1) default NULL,
  `TotalAmount` float(9,2) default NULL,
  `IsPostAuth` tinyint(1) default '0',
  `IsVoid` tinyint(1) default NULL,
  `PostAmount` float(9,2) default NULL,
  `PostRefNum` varchar(10) default NULL,
  `PostBatchNum` varchar(6) default NULL,
  `PostTimestamp` datetime default NULL,
  `PostTranCode` varchar(3) default NULL,
  `TerminalID` varchar(15) NOT NULL default ' ',
  PRIMARY KEY  (`ID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

CREATE TABLE `creditinfo` (
  `FirstName` varchar(15) default NULL,
  `LastName` varchar(20) default NULL,
  `Address` varchar(50) default NULL,
  `City` varchar(20) default NULL,
  `State` varchar(2) default NULL,
  `Zip` varchar(10) default NULL,
  `CC_Type` varchar(20) default NULL,
  `CC_Number` varchar(50) character set utf8 collate utf8_bin NOT NULL default '',
  `CC_Exp` varchar(5) default NULL,
  `CustomerID` int(10) unsigned NOT NULL default '0',
  `CCLastFor` varchar(4) NOT NULL default '',
  `Track2` varchar(100) default NULL,
  `CVVDATA` varchar(45) default NULL,
  PRIMARY KEY  (`CC_Number`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

CREATE TABLE `credittransinfo` (
  `InvoiceID` int(10) unsigned NOT NULL,
  `CC_Number` varchar(50) default NULL,
  `ExpDate` varchar(5) default NULL,
  `Track2` varchar(100) NOT NULL default '',
  `respind` tinyint(1) unsigned default NULL,
  `AuthCode` varchar(10) default NULL,
  `Amount` float(9,2) default NULL,
  `RefNum` varchar(10) default NULL,
  `AvsResltSect1` varchar(16) default NULL,
  `AvsResltSect2` varchar(16) default NULL,
  `AvsResltSect3` varchar(16) default NULL,
  `TimStamp` timestamp NOT NULL default CURRENT_TIMESTAMP on update CURRENT_TIMESTAMP,
  `CvvRefCode` varchar(1) default NULL,
  `Batchnum` varchar(6) default NULL,
  `TranCode` varchar(3) NOT NULL default '',
  `Sequence` int(12) NOT NULL auto_increment,
  `AvsResltCode` varchar(1) default NULL,
  `TotalAmount` float(9,2) default NULL,
  `IsPostAuth` tinyint(1) NOT NULL default '0',
  `IsVoid` tinyint(1) NOT NULL default '0',
  `PostAmount` float(9,2) default NULL,
  `PostRefNum` varchar(10) default NULL,
  `PostBatchNum` varchar(6) default NULL,
  `PostTimestamp` datetime default NULL,
  `PostTranCode` varchar(3) default NULL,
  `TerminalID` varchar(15) NOT NULL default ' ',
  PRIMARY KEY  (`InvoiceID`),
  KEY `Index_2` (`Sequence`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

CREATE TABLE `credittransinfomps` (
  `InvoiceID` int(10) unsigned NOT NULL default '0',
  `AcctNo` varchar(50) default NULL,
  `ExpDate` varchar(5) default NULL,
  `CardType` varchar(10) default NULL,
  `AmountPurchase` float(9,2) NOT NULL default '0.00',
  `AmountAuthorize` float(9,2) NOT NULL default '0.00',
  `AmountGratuity` float(9,2) NOT NULL default '0.00',
  `AmountTax` float(9,2) NOT NULL default '0.00',
  `TimStamp` timestamp NOT NULL default CURRENT_TIMESTAMP on update CURRENT_TIMESTAMP,
  `CVVData` varchar(45) default NULL,
  `AvsAddress` varchar(45) default NULL,
  `AvsZip` varchar(9) default NULL,
  `TranCode` varchar(25) NOT NULL default '',
  `AuthCode` varchar(50) default NULL,
  `AcqRefData` varchar(40) default NULL,
  `RecordNo` varchar(10) default NULL,
  `OperatorID` int(10) unsigned default NULL,
  `IsCaptured` tinyint(1) NOT NULL default '0',
  `IsVoid` tinyint(1) default NULL,
  `PostTimeStamp` timestamp NOT NULL default '1980-01-01 00:00:00',
  `AvsResult` varchar(5) default NULL,
  `CVVResult` varchar(5) default NULL,
  `RefNo` varchar(15) default NULL,
  `Track2` varchar(100) NOT NULL default '',
  `IsAdjusting` tinyint(1) NOT NULL default '0',
  `TransactionIDVCode` VARCHAR(20) default NULL,
  `VarLenFIDValue` VARCHAR(99) default NULL,
  `IsCloseBatch` TINYINT(1) NOT NULL DEFAULT '0' ,
  PRIMARY KEY  (`InvoiceID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

CREATE TABLE `credittransinfompshistory` (
  `InvoiceID` int(10) unsigned NOT NULL default '0',
  `AcctNo` varchar(50) default NULL,
  `ExpDate` varchar(5) default NULL,
  `CardType` varchar(10) default NULL,
  `AmountPurchase` float(9,2) NOT NULL default '0.00',
  `AmountAuthorize` float(9,2) NOT NULL default '0.00',
  `AmountGratuity` float(9,2) NOT NULL default '0.00',
  `AmountTax` float(9,2) NOT NULL default '0.00',
  `TimStamp` timestamp NOT NULL default CURRENT_TIMESTAMP on update CURRENT_TIMESTAMP,
  `CVVData` varchar(45) default NULL,
  `AvsAddress` varchar(45) default NULL,
  `AvsZip` varchar(9) default NULL,
  `TranCode` varchar(25) NOT NULL default '',
  `AuthCode` varchar(50) default NULL,
  `AcqRefData` varchar(40) default NULL,
  `RecordNo` varchar(10) default NULL,
  `OperatorID` int(10) unsigned default NULL,
  `IsCaptured` tinyint(1) NOT NULL default '0',
  `IsVoid` tinyint(1) default NULL,
  `PostTimeStamp` timestamp NOT NULL default '1980-01-01 00:00:00',
  `AvsResult` varchar(5) default NULL,
  `CVVResult` varchar(5) default NULL,
  `RefNo` varchar(15) default NULL,
  `Track2` varchar(100) NOT NULL default '',
  `IsAdjusting` tinyint(1) NOT NULL default '0',
  `TransactionIDVCode` VARCHAR(20) default NULL,
  `VarLenFIDValue` VARCHAR(99) default NULL,
  `IsCloseBatch` TINYINT(1) NOT NULL DEFAULT '0' ,
  PRIMARY KEY  (`InvoiceID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

CREATE TABLE `customer` (
  `CustomerID` int(10) NOT NULL auto_increment,
  `Name` varchar(50) character set utf8 default NULL,
  `Street` varchar(50) character set utf8 default NULL,
  `City` varchar(50) character set utf8 default NULL,
  `State` varchar(50) default NULL,
  `phone1` varchar(50) default NULL,
  `zip` varchar(50) default NULL,
  `comments` varchar(50) character set utf8 default NULL,
  `currnumber` varchar(100) default NULL,
  `comments2` varchar(50) character set utf8 default NULL,
  `type` varchar(45) NOT NULL default 'Z',
  `notesID` varchar(10)  default NULL,
  PRIMARY KEY  (`CustomerID`),
  KEY `CustomerID` (`CustomerID`),
  KEY `currnumber` (`currnumber`),
  KEY `phone1` (`phone1`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 AUTO_INCREMENT=11 ;

CREATE TABLE `customernotes` (
  `notesID` int(10)  NOT NULL auto_increment,
  `eNotes` varchar(100) DEFAULT NULL,
  `cNotes` varchar(100) DEFAULT NULL,
  PRIMARY KEY (`notesID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

CREATE TABLE `customer_order` (
  `InvoiceID` int(10) unsigned NOT NULL default '0',
  `FirstName` varchar(15) default NULL,
  `LastName` varchar(20) default NULL,
  `Address` varchar(50) default NULL,
  `City` varchar(20) default NULL,
  `State` varchar(2) default NULL,
  `Zip` varchar(10) default NULL,
  `CC_Type` varchar(20) default NULL,
  `CC_Number` varchar(100) character set utf8 collate utf8_bin default NULL,
  `CC_Exp` varchar(5) default NULL,
  `CustomerID` int(10) unsigned NOT NULL default '0',
  PRIMARY KEY  (`InvoiceID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

CREATE TABLE `debittransinfo` (
  `InvoiceID` int(10) NOT NULL default '0',
  `CC_Number` varchar(50) default NULL,
  `respind` tinyint(1) default NULL,
  `AuthCode` varchar(10) NOT NULL default '',
  `TimStamp` timestamp NOT NULL default CURRENT_TIMESTAMP on update CURRENT_TIMESTAMP,
  `Sequence` int(12) NOT NULL auto_increment,
  `TransCode` varchar(3) NOT NULL default '',
  `Amount` float(9,2) default NULL,
  `PinBlock` varchar(32) default NULL,
  `CashBackAmount` float(9,2) default NULL,
  `AccountType` varchar(10) default NULL,
  PRIMARY KEY  (`InvoiceID`),
  KEY `Index_2` (`Sequence`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

CREATE TABLE `description` (
  `ID` int(10) NOT NULL default '0',
  `specialtext` varchar(300) default NULL,
  `taxrate` double(15,5) default NULL,
  `tiprate` double(15,5) default NULL,
  `bagprinter` smallint(5) default NULL,
  `autoprintmap` tinyint(1) NOT NULL,
  `DminForcharge` double(15,5) default NULL,
  `DBversion` datetime default NULL,
  `reportprinter` int(10) default NULL,
  `specialtext2` varchar(300) default NULL,
  `PrintSeq` tinyint(1) NOT NULL,
  `ShowSeq` tinyint(1) NOT NULL,
  `ComboSeparator` varchar(300) default NULL,
  `PrefixString` varchar(10) default NULL,
  `MaxNumber` int(10) default NULL,
  `taxrate1` double NOT NULL default '0',
  `taxrate2` double NOT NULL default '0',
  `taxrate3` double NOT NULL default '0',
  `adjustPrice` tinyint(1) NOT NULL default '0',
  `adjustAmount` double NOT NULL default '0',
  `AdjustPriceWalkin` tinyint(1) NOT NULL default '0',
  `todaysIDPrint` tinyint(1) NOT NULL default '0',
  `todaysIDPrinter` int(10) default '0',
  PRIMARY KEY  (`ID`),
  KEY `ID` (`ID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

CREATE TABLE `employee` (
  `staffID` int(10) NOT NULL default '0',
  `Fname` varchar(50) character set utf8 default NULL,
  `Lname` varchar(50) character set utf8 default NULL,
  `role` int(10) default NULL,
  `phone` varchar(15) default NULL,
  `StartDate` datetime default NULL,
  `EndDate` datetime default NULL,
  `comments` varchar(50) character set utf8 default NULL,
  `Gender` tinyint(1) NOT NULL default '0',
  `password` varchar(50) default NULL,
  `pwdover` varchar(255) default NULL,
  PRIMARY KEY  (`staffID`),
  UNIQUE KEY `staffID` (`staffID`),
  UNIQUE KEY `password` (`password`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='InnoDB free: 31744 kB';

CREATE TABLE `employeecard` (
  `cardID` varchar(50) NOT NULL default '',
  `staffID` int(10) default NULL,
  `wage` decimal(19,4) default NULL,
  `lastactionid` int(10) default NULL,
  `ischeckedin` tinyint(1) NOT NULL default '0',
  PRIMARY KEY  (`cardID`),
  KEY `CardID` (`cardID`),
  KEY `lastactionid` (`lastactionid`),
  KEY `staffID` (`staffID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

CREATE TABLE `employeelog` (
  `ID` int(10) NOT NULL auto_increment,
  `cardID` varchar(50) default NULL,
  `intime` datetime default NULL,
  `outtime` datetime default NULL,
  PRIMARY KEY  (`ID`),
  KEY `ID` (`ID`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 AUTO_INCREMENT=10 ;

CREATE TABLE `getnewid` (
  `id` int(10) unsigned NOT NULL,
  `idtype` varchar(45) NOT NULL,
  `host` varchar(45) NOT NULL,
  PRIMARY KEY (`id`,`idtype`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

CREATE TABLE `giftcard` (
  `CardID` varchar(20) NOT NULL default '',
  `IssTime` timestamp NOT NULL default '0000-00-00 00:00:00',
  `SaleAmountTotal` double NOT NULL default '0',
  `DisAmountTotal` double NOT NULL default '0',
  `AmountTotal` double NOT NULL default '0',
  `Balance` double NOT NULL default '0',
  PRIMARY KEY  (`CardID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

CREATE TABLE `giftcard1` (
  `CardID` varchar(20) NOT NULL default '',
  `IssTime` timestamp NOT NULL default '0000-00-00 00:00:00',
  `CardAmount` double NOT NULL default '0',
  `DisAmount` double NOT NULL default '0',
  `Amount` double NOT NULL default '0',
  `Balance` double NOT NULL default '0',
  `ExTime` datetime NOT NULL default '0000-00-00 00:00:00',
  `PayMethod` varchar(20) default NULL,
  `CreditNo` varchar(18) default NULL,
  PRIMARY KEY  (`CardID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

CREATE TABLE `giftcardlog` (
  `CardID` varchar(20) NOT NULL default '',
  `OperateTime` timestamp NOT NULL default CURRENT_TIMESTAMP,
  `OperateType` varchar(20) default NULL,
  `CardAmount` double NOT NULL default '0',
  `Balance` double NOT NULL default '0',
  `WaiterID` int(10) default NULL,
  `InvoiceID` int(12) default NULL,
  `Disamount` double NOT NULL default '0',
  `Amount` double NOT NULL default '0',
  `PaymentMethod` varchar(20) default NULL,
  `CreditTransID` int(12) default NULL,
  `CheckNo` varchar(20) default NULL,
  `comments` varchar(20) default NULL,
  `void` tinyint(1) unsigned NOT NULL default '0',
  `CashierID` int(10) unsigned default NULL,
 `ManConfirm` tinyint(1) NOT NULL default '0',
  `cashierWaiterID` int(10) default NULL,
  PRIMARY KEY  (`CardID`,`OperateTime`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

CREATE TABLE `giftcardlog1` (
  `CardID` varchar(20) NOT NULL default '',
  `OperateTime` timestamp NOT NULL default CURRENT_TIMESTAMP on update CURRENT_TIMESTAMP,
  `OperateType` varchar(20) default NULL,
  `CardAmount` double NOT NULL default '0',
  `Balance` double NOT NULL default '0',
  `WaiterID` int(10) default NULL,
  `InvoiceID` int(12) default NULL,
  PRIMARY KEY  (`CardID`,`OperateTime`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

CREATE TABLE `giftcard_log` (
  `Record_num` int(10) NOT NULL,
  `Operate` varchar(1) default NULL,
  `Card_ID` varchar(20) default NULL,
  `Operate_time` datetime default NULL,
  `StaffID` int(10) default NULL,
  `Amount` int(10) default NULL,
  `Balance` int(10) default NULL,
  `memo` varchar(50) default NULL,
  `validflag` tinyint(1) NOT NULL,
  PRIMARY KEY  (`Record_num`),
  KEY `cid` (`Card_ID`),
  KEY `Record_num` (`Record_num`),
  KEY `StaffID` (`StaffID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

CREATE TABLE `gifttransinfo` (
  `InvoiceID` int(11) NOT NULL default '0',
  `Track2` varchar(40) NOT NULL default '',
  `respind` tinyint(1) default NULL,
  `AuthCode` varchar(10) default NULL,
  `CardBalance` float(9,2) default NULL,
  `TimStamp` timestamp NOT NULL default CURRENT_TIMESTAMP on update CURRENT_TIMESTAMP,
  `Amount` float(9,2) default NULL,
  `IsVoid` tinyint(1) default NULL,
  `Footer1` varchar(24) default NULL,
  `Footer2` varchar(24) default NULL,
  `Footer3` varchar(24) default NULL,
  `TransCode` varchar(3) default NULL,
  `KeyCode` varchar(2) default NULL,
  PRIMARY KEY  (`InvoiceID`),
  KEY `track2` (`Track2`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

CREATE TABLE `incomesum` (
  `dateperiod` varchar(8) NOT NULL default '',
  `DeliverySum` double(15,5) default NULL,
  `DeliveryItems` int(10) default NULL,
  `DineInSum` double(15,5) default NULL,
  `DineInItems` int(10) default NULL,
  `WaitSum` double(15,5) default NULL,
  `WaitItems` int(10) default NULL,
  `PickUpSum` double(15,5) default NULL,
  `PickUpItems` int(10) default NULL,
  PRIMARY KEY  (`dateperiod`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

CREATE TABLE `invoice` (
  `InvoiceID` int(10) NOT NULL default '0',
  `OrderID` int(10) default NULL,
  `Amount` decimal(19,4) NOT NULL default '0.0000',
  `Tip` decimal(19,4) NOT NULL default '0.0000',
  `CashierID` int(10) default NULL,
  `paytime` timestamp NOT NULL default CURRENT_TIMESTAMP on update CURRENT_TIMESTAMP,
  `paymenttype` tinyint(3) unsigned default NULL,
  `voidflag` tinyint(1) NOT NULL default '0',
  `SubOrderID` varchar(1) NOT NULL default ' ',
  `TipConfirm` tinyint(1) NOT NULL default '0',
  `ManConfirm` tinyint(1) NOT NULL default '0',
  `cashierWaiterID` int(10) default NULL,
  PRIMARY KEY  (`InvoiceID`),
  KEY `invoceID` (`InvoiceID`),
  KEY `OperateID` (`CashierID`),
  KEY `orderID` (`OrderID`),
  KEY `paymenttype` (`paymenttype`),
  KEY `paytime` (`paytime`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

CREATE TABLE `invoicehistory` (
  `InvoiceID` int(10) NOT NULL default '0',
  `OrderID` int(10) default NULL,
  `Amount` decimal(19,4) NOT NULL default '0.0000',
  `Tip` decimal(19,4) NOT NULL default '0.0000',
  `CashierID` int(10) default NULL,
  `paytime` timestamp NOT NULL default CURRENT_TIMESTAMP on update CURRENT_TIMESTAMP,
  `paymenttype` tinyint(3) unsigned default NULL,
  `voidflag` tinyint(1) NOT NULL default '0',
  `SubOrderID` varchar(1) NOT NULL default ' ',
  `TipConfirm` tinyint(1) NOT NULL default '0',
  `ManConfirm` tinyint(1) NOT NULL default '0',
  `cashierWaiterID` int(10) default NULL,
  PRIMARY KEY  (`InvoiceID`),
  KEY `invoceID` (`InvoiceID`),
  KEY `OperateID` (`CashierID`),
  KEY `orderID` (`OrderID`),
  KEY `paymenttype` (`paymenttype`),
  KEY `paytime` (`paytime`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

CREATE TABLE `managerright` (
  `enName` varchar(50) NOT NULL default '',
  `cnName` varchar(50) NOT NULL default '',
  `Flag` int(10) default NULL,
  `Allowed` tinyint(1) NOT NULL,
  `Manager39` tinyint(1) NOT NULL default '0',
  `Manager150` tinyint(1) NOT NULL default '0',
  `Manager135` tinyint(1) NOT NULL default '0',
  `Manager145` tinyint(1) NOT NULL default '0',
  `Manager159` tinyint(1) NOT NULL default '0',
  `Manager164` tinyint(1) NOT NULL default '0',
  PRIMARY KEY  (`enName`,`cnName`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

CREATE TABLE `menucatagory` (
  `MenuCatagoryID` int(10) NOT NULL default '0',
  `EnName` varchar(50) default NULL,
  `CNCatagoryName` varchar(50) default NULL,
  `disabled` tinyint(1) NOT NULL default '0',
  `section` int(10) default NULL,
  `PrintSeq` int(10) default NULL,
  `ShowSeq` int(10) default NULL,
  `SubMenuRows` int(10) unsigned default NULL,
  `TaxType` int(10) NOT NULL default '0',
  `AlsoPrintAlone` tinyint(1) NOT NULL default '0',
  `StartTime` int(10) NOT NULL default '0',
  `EndTime` int(10) NOT NULL default '24',
  `NotShowWeekDays` varchar(7) default NULL,
  PRIMARY KEY  (`MenuCatagoryID`),
  KEY `MenuCatagoryID` (`MenuCatagoryID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

CREATE TABLE `menuitemspecial` (
  `ID` int(10) NOT NULL default '0',
  `MenuItemID` varchar(50) default NULL,
  `methodid` int(10) default NULL,
  `specialid` int(10) default NULL,
  PRIMARY KEY  (`ID`),
  KEY `ID` (`ID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

CREATE TABLE `orderdetails` (
  `indexs` int(10) NOT NULL default '0',
  `dishID` varchar(50) NOT NULL default '0',
  `OrderID` int(10) NOT NULL default '0',
  `quantity` DOUBLE default NULL,
  `Fee` double NOT NULL default '0',
  `dishprice` double NOT NULL default '0',
  `finished` tinyint(1) NOT NULL default '0',
  `deleted` tinyint(1) NOT NULL default '0',
  `printtime` datetime default NULL,
  `taxable` tinyint(1) NOT NULL default '1',
  `TaxType` int(10) NOT NULL default '0',
  `freedish` tinyint(1) NOT NULL default '0',
  `freeTag` tinyint(1) NOT NULL default '0',
  `PrintSeq` int(10) default NULL,
  `IsAccounted` tinyint(1) NOT NULL default '0',
  `IsColor` tinyint(1) NOT NULL default '0',
  `IsSendAll` tinyint(1) NOT NULL default '0',
  `IsPaid` tinyint(1) NOT NULL default '0',
  `CookStatus` int(1) NOT NULL default '0',
  PRIMARY KEY  (`indexs`,`OrderID`),
  KEY `finished` (`finished`),
  KEY `OrderID` (`OrderID`),
  KEY `printtime` (`printtime`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

CREATE TABLE `orderdetailshistory` (
  `indexs` int(10) NOT NULL default '0',
  `dishID` varchar(50) NOT NULL default '0',
  `OrderID` int(10) NOT NULL default '0',
  `quantity` DOUBLE default NULL,
  `Fee` double NOT NULL default '0',
  `dishprice` double NOT NULL default '0',
  `finished` tinyint(1) NOT NULL default '0',
  `deleted` tinyint(1) NOT NULL default '0',
  `printtime` datetime default NULL,
  `taxable` tinyint(1) NOT NULL default '1',
  `TaxType` int(10) NOT NULL default '0',
  `freedish` tinyint(1) NOT NULL default '0',
  `freeTag` tinyint(1) NOT NULL default '0',
  `PrintSeq` int(10) default NULL,
  `IsAccounted` tinyint(1) NOT NULL default '0',
  `IsColor` tinyint(1) NOT NULL default '0',
  `IsSendAll` tinyint(1) NOT NULL default '0',
  `IsPaid` tinyint(1) NOT NULL default '0',
  `CookStatus` int(1) NOT NULL default '0',
  PRIMARY KEY  (`indexs`,`OrderID`),
  KEY `finished` (`finished`),
  KEY `OrderID` (`OrderID`),
  KEY `printtime` (`printtime`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

CREATE TABLE `orderdetails_0921` (
  `indexs` int(10) NOT NULL default '0',
  `dishID` varchar(50) character set latin1 NOT NULL default '0',
  `OrderID` int(10) NOT NULL default '0',
  `quantity` int(10) default NULL,
  `Fee` double NOT NULL default '0',
  `dishprice` double NOT NULL default '0',
  `finished` tinyint(1) NOT NULL default '0',
  `deleted` tinyint(1) NOT NULL default '0',
  `printtime` datetime default NULL,
  `taxable` tinyint(1) NOT NULL default '1',
  `freedish` tinyint(1) NOT NULL default '0',
  `PrintSeq` int(10) default NULL,
  `IsAccounted` tinyint(1) NOT NULL default '0',
  `IsSendAll` tinyint(1) NOT NULL default '0',
  `IsPaid` tinyint(1) NOT NULL default '0',
  `IsColor` tinyint(1) NOT NULL default '0'
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

CREATE TABLE `orderntable` (
  `OrderID` int(10) NOT NULL default '0',
  `TbID` varchar(50) NOT NULL default '',
  `Status` int(5) NOT NULL default '1',
  PRIMARY KEY  (`OrderID`,`TbID`),
  KEY `OrderID` (`OrderID`),
  KEY `TableID` (`TbID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

CREATE TABLE `orders` (
  `OrderID` int(10) NOT NULL default '0',
  `TimStamp` timestamp NOT NULL default CURRENT_TIMESTAMP,
  `WaiterID` int(10) default NULL,
  `Orderdate` datetime default NULL,
  `OrderType` int(10) default NULL,
  `CustomerID` int(10) default NULL,
  `PayStatus` tinyint(1) NOT NULL default '0',
  `Tables` varchar(50) default NULL,
  `Subtotal` double(15,5) NOT NULL default '0.00000',
  `Tax` double(15,5) NOT NULL default '0.00000',
  `dcharge` double(15,5) NOT NULL default '0.00000',
  `taxable` tinyint(1) NOT NULL default '1',
  `numPerson` smallint(5) NOT NULL default '1',
  `todaysID` int(10) NOT NULL default '0',
  `finished` tinyint(1) NOT NULL default '0',
  `paidamount` double(15,5) NOT NULL default '0.00000',
  `discount` double(15,5) NOT NULL default '0.00000',
  `locked` tinyint(1) NOT NULL default '0',
  `tipRateBeforePay` double unsigned NOT NULL default '0',
  `CustName` varchar(50) default NULL,
  `Printed` tinyint(1) unsigned NOT NULL default '0',
  `OrderIsVoid` tinyint(1) unsigned NOT NULL default '0',
  `BuffetTimeWarned` tinyint(1) unsigned default NULL,
  `IsPrintChecked` tinyint(1) unsigned NOT NULL default '0',
  `gratuity` double NOT NULL default '0',
  `couponTotal` double NOT NULL default '0',
  `couponCodes` varchar(100) NOT NULL default '',
  `longTimeFlag` tinyint(1) unsigned NOT NULL default '0',
  `FristTime` varchar(20) default NULL,
  `CookStatus` int(1) NOT NULL default '0',
  `OtherCharge` double(15,5) default '0.00000',
  `LastEditTime` varchar(20) default NULL,
  `OperaterID` int(10) default NULL,
  PRIMARY KEY  (`OrderID`),
  UNIQUE KEY `OrderID` (`OrderID`),
  KEY `CustomerID` (`CustomerID`),
  KEY `finished` (`finished`),
  KEY `Orderdate` (`Orderdate`),
  KEY `OrderType` (`OrderType`),
  KEY `TimStamp` (`TimStamp`),
  KEY `todaysID` (`todaysID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

CREATE TABLE `ordershistory` (
  `OrderID` int(10) NOT NULL default '0',
  `TimStamp` timestamp NOT NULL default CURRENT_TIMESTAMP, 
  `WaiterID` int(10) default NULL,
  `Orderdate` datetime default NULL,
  `OrderType` int(10) default NULL,
  `CustomerID` int(10) default NULL,
  `PayStatus` tinyint(1) NOT NULL default '0',
  `Tables` varchar(50) default NULL,
  `Subtotal` double(15,5) NOT NULL default '0.00000',
  `Tax` double(15,5) NOT NULL default '0.00000',
  `dcharge` double(15,5) NOT NULL default '0.00000',
  `taxable` tinyint(1) NOT NULL default '1',
  `numPerson` smallint(5) NOT NULL default '1',
  `todaysID` int(10) NOT NULL default '0',
  `finished` tinyint(1) NOT NULL default '0',
  `paidamount` double(15,5) NOT NULL default '0.00000',
  `discount` double(15,5) NOT NULL default '0.00000',
  `locked` tinyint(1) NOT NULL default '0',
  `tipRateBeforePay` double unsigned NOT NULL default '0',
  `CustName` varchar(50) default NULL,
  `Printed` tinyint(1) unsigned NOT NULL default '0',
  `OrderIsVoid` tinyint(1) unsigned NOT NULL default '0',
  `BuffetTimeWarned` tinyint(1) unsigned default NULL,
  `IsPrintChecked` tinyint(1) unsigned NOT NULL default '0',
  `gratuity` double NOT NULL default '0',
  `couponTotal` double NOT NULL default '0',
  `couponCodes` varchar(100) NOT NULL default '',
  `longTimeFlag` tinyint(1) unsigned NOT NULL default '0',
  `FristTime` varchar(20) default NULL,
   `CookStatus` int(1) NOT NULL default '0',
   `OtherCharge` double(15,5) default '0.00000',
   `LastEditTime` varchar(20) default NULL,
   `OperaterID` int(10) default NULL,
  PRIMARY KEY  (`OrderID`),
  UNIQUE KEY `OrderID` (`OrderID`),
  KEY `CustomerID` (`CustomerID`),
  KEY `finished` (`finished`),
  KEY `Orderdate` (`Orderdate`),
  KEY `OrderType` (`OrderType`),
  KEY `TimStamp` (`TimStamp`),
  KEY `todaysID` (`todaysID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

CREATE TABLE `paymentinfo` (
  `OrderID` int(12) NOT NULL default '0',
  `VisaAmount` double(15,5) NOT NULL default '0.00000',
  `MastAmount` double(15,5) NOT NULL default '0.00000',
  `ExpressAmount` double(15,5) NOT NULL default '0.00000',
  `DiscoverAmount` double(15,5) NOT NULL default '0.00000',
  `CheckAmount` double(15,5) NOT NULL default '0.00000',
  `CouponAmount` double(15,5) NOT NULL default '0.00000',
  `GiftCardAmount` double(15,5) NOT NULL default '0.00000',
  `CashAmount` double(15,5) NOT NULL default '0.00000',
  `VisaNo` varchar(18) default NULL,
  `MastNo` varchar(18) default NULL,
  `DiscoverNo` varchar(18) default NULL,
  `ExpressNo` varchar(18) default NULL,
  `CheckNo` varchar(18) default NULL,
  `CouponNo` varchar(18) default NULL,
  `GiftCardNo` varchar(18) default NULL,
  PRIMARY KEY  (`OrderID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

CREATE TABLE `paymenttypeselect` (
  `name` varchar(12) NOT NULL default '',
  `Val` tinyint(1) NOT NULL default '0',
  PRIMARY KEY  (`name`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

CREATE TABLE `payoutcode` (
  `CategoryID` int(11) NOT NULL default '0',
  `enName` varchar(100) default NULL,
  `cnName` varchar(100) default NULL,
  PRIMARY KEY  (`CategoryID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

CREATE TABLE `phoneinfo` (
  `ID` int(10) NOT NULL auto_increment,
  `PhoneNo` varchar(20) default NULL,
  `Name` varchar(50) default NULL,
  `Line` int(10) default NULL,
  `CallTime` timestamp NOT NULL default CURRENT_TIMESTAMP on update CURRENT_TIMESTAMP,
  `CallDate` datetime default NULL,
  `Status` varchar(1) default NULL,
  PRIMARY KEY  (`ID`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 AUTO_INCREMENT=2 ;

CREATE TABLE `printset` (
  `dishid` varchar(50) NOT NULL default '',
  `printerid` int(10) NOT NULL default '0',
  PRIMARY KEY  (`dishid`,`printerid`),
  KEY `dishid` (`dishid`),
  KEY `printernum` (`printerid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

CREATE TABLE `quickspecial` (
  `ID` int(10) NOT NULL default '0',
  `menucatid` int(10) default NULL,
  `methodid` int(10) default NULL,
  `specialid` int(10) default NULL,
  `disabled` tinyint(1) NOT NULL default '0',
  `ShowSeq` int(10) NOT NULL default '100',
  `PrintSeq` int(10) unsigned NOT NULL default '100',
  PRIMARY KEY  (`ID`),
  KEY `ID` (`ID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

CREATE TABLE `reservation` (
  `ReserveID` int(10) NOT NULL,
  `cid` int(10) default NULL,
  `DinnerTime` datetime default NULL,
  `DinnerDate` datetime default NULL,
  PRIMARY KEY  (`ReserveID`),
  KEY `DinnerDate` (`DinnerDate`),
  KEY `ReserveID` (`ReserveID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

CREATE TABLE `sections` (
  `roomid` int(10) NOT NULL default '0',
  `cnname` varchar(50) NOT NULL default '',
  `enname` varchar(50) NOT NULL default '',
  `autolock` tinyint(1) NOT NULL,
  `enable` tinyint(1) NOT NULL,
  `ShowSeq` int(10) NOT NULL default '0',
  `isbuffet` int(10) NOT NULL default '0',
  PRIMARY KEY  (`roomid`),
  KEY `roomid` (`roomid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

CREATE TABLE `selfcustinfo` (
  `CustomerID` int(10) NOT NULL default '0',
  `Name` varchar(50) default NULL,
  `Street` varchar(50) default NULL,
  `City` varchar(50) default NULL,
  `State` varchar(50) default NULL,
  `phone1` varchar(50) default NULL,
  `zip` varchar(50) default NULL,
  `comments` varchar(50) default NULL,
  PRIMARY KEY  (`CustomerID`),
  KEY `CustomerID` (`CustomerID`),
  KEY `phone1` (`phone1`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

CREATE TABLE `sequence` (
  `id` int(11) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

CREATE TABLE `spcat` (
  `spcatid` int(10) NOT NULL default '0',
  `cnname` varchar(50) default NULL,
  `enname` varchar(50) character set latin1 default NULL,
  `disabled` tinyint(1) NOT NULL default '0',
  `ShowSeq` int(10) NOT NULL default '100',
  PRIMARY KEY  (`spcatid`),
  KEY `spcatid` (`spcatid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

CREATE TABLE `special` (
  `S_ID` int(10) NOT NULL default '0',
  `Content` varchar(50) default NULL,
  `enContent` varchar(50) default NULL,
  `Catagory` int(10) default NULL,
  `p1` decimal(19,4) default NULL,
  `p2` decimal(19,4) default NULL,
  `p3` decimal(19,4) default NULL,
  `p4` decimal(19,4) default NULL,
  `p5` decimal(19,4) default NULL,
  `p6` decimal(19,4) default NULL,
  `p7` decimal(19,4) default NULL,
  `NotPrintTo` varchar(50) character set latin1 default NULL,
  `ShowInCUSTMode` tinyint(1) NOT NULL default '1',
  `p11` double(15,5) default NULL,
  `p12` double(15,5) default NULL,
  `p13` double(15,5) default NULL,
  `p14` double(15,5) default NULL,
  `p15` double(15,5) default NULL,
  `p16` double(15,5) default NULL,
  `disabled` tinyint(1) NOT NULL default '0',
  `ShowSeq` int(10) NOT NULL default '100',
  PRIMARY KEY  (`S_ID`),
  KEY `TasteID` (`S_ID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

CREATE TABLE `specialdetails` (
  `oid` int(10) NOT NULL default '0',
  `dishidindex` int(10) NOT NULL default '0',
  `specialid` int(10) NOT NULL default '0',
  `methodid` int(10) default NULL,
  `subfee` decimal(19,4) NOT NULL default '0.0000',
  `item` int(10) NOT NULL default '1',
  `addid` int(2) NOT NULL default '1',
  PRIMARY KEY  (`oid`,`dishidindex`,`specialid`),
  KEY `dishid` (`dishidindex`),
  KEY `oid` (`oid`),
  KEY `specialid` (`specialid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

CREATE TABLE `specialdetailshistory` (
  `oid` int(10) NOT NULL default '0',
  `dishidindex` int(10) NOT NULL default '0',
  `specialid` int(10) NOT NULL default '0',
  `methodid` int(10) default NULL,
  `subfee` decimal(19,4) NOT NULL default '0.0000',
  `item` int(10) NOT NULL default '1',
  `addid` int(2) NOT NULL default '1',
  PRIMARY KEY  (`oid`,`dishidindex`,`specialid`),
  KEY `dishid` (`dishidindex`),
  KEY `oid` (`oid`),
  KEY `specialid` (`specialid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

CREATE TABLE `splitinfor` (
  `orderID` int(10) NOT NULL default '0',
  `NewID` int(10) NOT NULL default '0',
  PRIMARY KEY  (`orderID`,`NewID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

CREATE TABLE `sprequestinfo` (
  `ID` int(10) NOT NULL,
  `SubMenuID` varchar(50) default NULL,
  `CategoryID` varchar(50) default NULL,
  `NoOfFree` int(10) default NULL,
  `Price` double(7,2) default NULL,
  PRIMARY KEY  (`ID`),
  KEY `CategoryID` (`CategoryID`),
  KEY `ID` (`ID`),
  KEY `SubMenuID` (`SubMenuID`),
  KEY `Number` (`NoOfFree`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

CREATE TABLE `submenu` (
  `SubmenuID` varchar(50) NOT NULL default '',
  `EnDishName` varchar(50) default NULL,
  `CnDishName` varchar(50) default NULL,
  `Price1` double(15,5) default NULL,
  `menucatagoryID` int(10) default NULL,
  `Price2` double(15,5) default NULL,
  `spcat` int(10) default NULL,
  `taxable` tinyint(1) NOT NULL default '1',
  `parentid` varchar(50) default NULL,
  `nextcat` int(10) default NULL,
  `ItemDesc` varchar(50) default NULL,
  `smPic` varchar(50) default NULL,
  `lgPic` varchar(50) character set latin1 default NULL,
  `isComboDish` tinyint(1) NOT NULL default '0',
  `Hide` tinyint(1) NOT NULL default '0',
  `isSubItem` tinyint(1) NOT NULL default '0',
  `NextCatCount` int(10) default NULL,
  `AutoAppend` tinyint(1) NOT NULL default '0',
  `Disabled` tinyint(1) NOT NULL default '0',
  `ShowSeq` int(10) NOT NULL default '100',
  `IsAccounted` tinyint(1) NOT NULL default '0',
  `adjustPrice` tinyint(1) NOT NULL default '0',
  `orgPrice1` double NOT NULL default '0',
  `orgPrice2` double NOT NULL default '0',
  `IsColor` tinyint(1) NOT NULL default '0',
  `DishPrintSeq` int(10) NOT NULL default '0',
  `NotPrintInPack`  tinyint(1) NOT NULL default '0',
  `PrintLabel`  tinyint(1) NOT NULL default '0',
  PRIMARY KEY  (`SubmenuID`),
  KEY `menucatagoryID` (`menucatagoryID`),
  KEY `parentid` (`parentid`),
  KEY `SubmenuID` (`SubmenuID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

CREATE TABLE `suborders` (
  `OrderID` int(10) NOT NULL default '0',
  `PayStatus` tinyint(1) NOT NULL default '0',
  `Subtotal` double(15,5) NOT NULL default '0.00000',
  `finished` tinyint(1) NOT NULL default '0',
  `paidamount` double(15,5) NOT NULL default '0.00000',
  `discount` double(15,5) NOT NULL default '0.00000',
  `locked` tinyint(1) NOT NULL default '0',
  `SubOrderID` varchar(1) NOT NULL default '',
  `couponTotal` double NOT NULL default '0',
  `gratuity` double NOT NULL default '0',
  `couponCodes` varchar(100) NOT NULL default '',
  PRIMARY KEY  (`OrderID`,`SubOrderID`),
  KEY `finished` (`finished`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

CREATE TABLE `subordershistory` (
  `OrderID` int(10) NOT NULL default '0',
  `PayStatus` tinyint(1) NOT NULL default '0',
  `Subtotal` double(15,5) NOT NULL default '0.00000',
  `finished` tinyint(1) NOT NULL default '0',
  `paidamount` double(15,5) NOT NULL default '0.00000',
  `discount` double(15,5) NOT NULL default '0.00000',
  `locked` tinyint(1) NOT NULL default '0',
  `SubOrderID` varchar(1) NOT NULL default '',
  `couponTotal` double NOT NULL default '0',
  `gratuity` double NOT NULL default '0',
  `couponCodes` varchar(100) NOT NULL default '',
  PRIMARY KEY  (`OrderID`,`SubOrderID`),
  KEY `finished` (`finished`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

CREATE TABLE `t` (
  `ts1` timestamp NOT NULL default '0000-00-00 00:00:00',
  `ts2` timestamp NOT NULL default CURRENT_TIMESTAMP
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

CREATE TABLE `tableengaged` (
  `ID` int(10) NOT NULL default '0',
  `CustomerID` int(10) NOT NULL default '0',
  `PhoneNum` varchar(25) default NULL,
  `StartTime` datetime default NULL,
  `EndTime` datetime default NULL,
  `TimStamp` timestamp NOT NULL default CURRENT_TIMESTAMP,
  `NumPerson` int(10) NOT NULL default '1',
  `TableID` varchar(30) default NULL,
  `Deposit` float(7,2) NOT NULL default '0.00',
  `PaymentType` int(10) NOT NULL default '0',
  PRIMARY KEY  (`ID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

CREATE TABLE `tablesections` (
  `roomid` int(10) NOT NULL default '0',
  `cnname` varchar(50) character set utf8 default NULL,
  `enname` varchar(50) default NULL,
  `autolock` tinyint(1) NOT NULL,
  PRIMARY KEY  (`roomid`),
  KEY `roomid` (`roomid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

CREATE TABLE `tablesetting` (
  `Section` int(10) default NULL,
  `x` int(10) default NULL,
  `y` int(10) default NULL,
  `TbID` varchar(50) NOT NULL default '',
  `size` tinyint(3) unsigned default NULL,
  `NumPerson` smallint(5) NOT NULL default '1',
  `Width` int(10) default NULL,
  `Height` int(10) default NULL,
  `FigureType` smallint(5) NOT NULL default '0',
  `Fontsize` float(5,2) NOT NULL default '9.00',
  PRIMARY KEY  (`TbID`),
  UNIQUE KEY `tbID` (`TbID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

CREATE TABLE `tablesettinglog` (
  `WaiterID` int(11) NOT NULL default '0',
  `TimStamp` timestamp NOT NULL default CURRENT_TIMESTAMP,
  `OperateType` varchar(20) NOT NULL default '',
  `TableID` varchar(50) NOT NULL default '',
  `OrderID` int(10) NOT NULL default '0',
  PRIMARY KEY  (`TimStamp`,`TableID`,`OrderID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

CREATE TABLE `tempinvoice` (
  `InvoiceID` int(10) NOT NULL default '0',
  `OrderID` int(10) default NULL,
  `Amount` decimal(19,4) default NULL,
  `Tip` decimal(19,4) default NULL,
  `CashierID` int(10) default NULL,
  `paytime` datetime default NULL,
  `paymenttype` tinyint(3) unsigned default NULL,
  `voidflag` tinyint(1) NOT NULL,
  PRIMARY KEY  (`InvoiceID`),
  KEY `invoceID` (`InvoiceID`),
  KEY `OperateID` (`CashierID`),
  KEY `orderID` (`OrderID`),
  KEY `paymenttype` (`paymenttype`),
  KEY `paytime` (`paytime`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

CREATE TABLE `temporder1` (
  `OrderID` int(10) NOT NULL default '0',
  `Orderdate` datetime default NULL,
  PRIMARY KEY  (`OrderID`),
  KEY `Orderdate` (`Orderdate`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

CREATE TABLE `temporderdetails` (
  `indexs` int(10) NOT NULL default '0',
  `DishID` varchar(10) default NULL,
  `OrderID` int(10) NOT NULL default '0',
  `quantity` int(10) default NULL,
  `Fee` double(15,5) default NULL,
  `dishprice` double(15,5) default NULL,
  `finished` tinyint(1) NOT NULL,
  `deleted` tinyint(1) NOT NULL,
  `printtime` datetime default NULL,
  `taxable` tinyint(1) NOT NULL,
  `freedish` tinyint(1) NOT NULL,
  `PrintSeq` int(10) default NULL,
  PRIMARY KEY  (`indexs`,`OrderID`),
  KEY `finished` (`finished`),
  KEY `OrderID` (`OrderID`),
  KEY `printtime` (`printtime`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

CREATE TABLE `temporderntable` (
  `OrderID` int(10) NOT NULL default '0',
  `TbID` varchar(50) NOT NULL default '',
  PRIMARY KEY  (`OrderID`,`TbID`),
  KEY `OrderID` (`OrderID`),
  KEY `TableID` (`TbID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

CREATE TABLE `temporders` (
  `OrderID` int(10) NOT NULL default '0',
  `TimStamp` timestamp NOT NULL default CURRENT_TIMESTAMP,
  `WaiterID` int(10) default NULL,
  `Orderdate` datetime NOT NULL default '0000-00-00 00:00:00',
  `OrderType` int(10) default NULL,
  `CustomerID` int(10) default NULL,
  `PayStatus` tinyint(1) NOT NULL default '0',
  `Tables` varchar(50) default NULL,
  `Subtotal` double(15,5) NOT NULL default '0.00000',
  `Tax` double(15,5) NOT NULL default '0.00000',
  `dcharge` double(15,5) NOT NULL default '0.00000',
  `taxable` tinyint(1) NOT NULL default '1',
  `numPerson` smallint(5) NOT NULL default '1',
  `TodaysID` int(10) default NULL,
  `finished` tinyint(1) NOT NULL default '0',
  `paidamount` double(15,5) NOT NULL default '0.00000',
  `discount` double(15,5) NOT NULL default '0.00000',
  `locked` tinyint(1) NOT NULL default '0',
  `tipRateBeforePay` int(10) NOT NULL default '0',
  `CustName` varchar(50) default NULL,
  `id` int(10) NOT NULL auto_increment,
  `Printed` tinyint(1) NOT NULL default '0',
  `OrderIsVoid` tinyint(1) NOT NULL default '0',
  `BuffetTimeWarned` tinyint(1) unsigned default NULL,
  `IsPrintChecked` tinyint(1) unsigned NOT NULL default '0',
  `gratuity` double NOT NULL default '0',
  `couponTotal` double NOT NULL default '0',
  `couponCodes` varchar(100) NOT NULL default '',
  PRIMARY KEY  (`id`),
  UNIQUE KEY `OrderID` (`OrderID`),
  KEY `CustomerID` (`CustomerID`),
  KEY `finished` (`finished`),
  KEY `Orderdate` (`Orderdate`),
  KEY `OrderType` (`OrderType`),
  KEY `TimStamp` (`TimStamp`),
  KEY `TodaysID` (`TodaysID`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 AUTO_INCREMENT=11 ;

CREATE TABLE `tempspecialdetails` (
  `oid` int(10) NOT NULL default '0',
  `dishidindex` int(10) NOT NULL default '0',
  `specialid` int(10) NOT NULL default '0',
  `methodid` int(10) default NULL,
  `subfee` decimal(19,4) default NULL,
  `item` int(10) default NULL,
  PRIMARY KEY  (`oid`,`dishidindex`,`specialid`),
  KEY `dishid` (`dishidindex`),
  KEY `oid` (`oid`),
  KEY `specialid` (`specialid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

CREATE TABLE `test1` (
  `OrderID` int(10) NOT NULL default '0',
  `tIMSTAMP` timestamp NOT NULL default CURRENT_TIMESTAMP,
  `WaiterID` int(10) default NULL,
  `Orderdate` timestamp NOT NULL default '0000-00-00 00:00:00',
  `OrderType` int(10) default NULL,
  `CustomerID` int(10) default NULL,
  `PayStatus` tinyint(1) default NULL,
  `Tables` varchar(50) default NULL,
  `Subtotal` double(15,5) default NULL,
  `Tax` double(15,5) default NULL,
  `dcharge` double(15,5) default NULL,
  `taxable` tinyint(1) default NULL,
  `numPerson` smallint(5) default NULL,
  `todaysID` int(10) default NULL,
  `finished` tinyint(1) default NULL,
  `paidamount` double(15,5) default NULL,
  `discount` double(15,5) default NULL,
  `locked` tinyint(1) default NULL,
  PRIMARY KEY  (`OrderID`),
  UNIQUE KEY `OrderID` (`OrderID`),
  KEY `CustomerID` (`CustomerID`),
  KEY `finished` (`finished`),
  KEY `Orderdate` (`Orderdate`),
  KEY `OrderType` (`OrderType`),
  KEY `TimStamp` (`tIMSTAMP`),
  KEY `todaysID` (`todaysID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

CREATE TABLE `test2` (
  `OrderID` int(10) NOT NULL default '0',
  `tIMSTAMP` timestamp NOT NULL default CURRENT_TIMESTAMP,
  `WaiterID` int(10) default NULL,
  `Orderdate` timestamp NOT NULL default '0000-00-00 00:00:00',
  `OrderType` int(10) default NULL,
  `CustomerID` int(10) default NULL,
  `PayStatus` tinyint(1) default NULL,
  `Tables` varchar(50) default NULL,
  `Subtotal` double(15,5) default NULL,
  `Tax` double(15,5) default NULL,
  `dcharge` double(15,5) default NULL,
  `taxable` tinyint(1) default NULL,
  `numPerson` smallint(5) default NULL,
  `todaysID` int(10) default NULL,
  `finished` tinyint(1) default NULL,
  `paidamount` double(15,5) default NULL,
  `discount` double(15,5) default NULL,
  `locked` tinyint(1) default NULL,
  `ID` int(10) NOT NULL auto_increment,
  PRIMARY KEY  (`ID`),
  UNIQUE KEY `OrderID` (`OrderID`),
  KEY `CustomerID` (`CustomerID`),
  KEY `finished` (`finished`),
  KEY `Orderdate` (`Orderdate`),
  KEY `OrderType` (`OrderType`),
  KEY `TimStamp` (`tIMSTAMP`),
  KEY `todaysID` (`todaysID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

CREATE TABLE `testdetails` (
  `index` int(10) NOT NULL default '0',
  `DishID` varchar(10) default NULL,
  `OrderID` int(10) NOT NULL default '0',
  `quantity` int(10) default NULL,
  `Fee` double(15,5) default NULL,
  `dishprice` double(15,5) default NULL,
  `finished` tinyint(1) NOT NULL,
  `deleted` tinyint(1) NOT NULL,
  `printtime` datetime default NULL,
  `taxable` tinyint(1) NOT NULL,
  `freedish` tinyint(1) NOT NULL,
  PRIMARY KEY  (`index`,`OrderID`),
  KEY `finished` (`finished`),
  KEY `OrderID` (`OrderID`),
  KEY `printtime` (`printtime`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

CREATE TABLE `viewbuffetorder` (
  `id` int(10) unsigned NOT NULL auto_increment,
  `customer` varchar(45) default NULL,
  `customerType` varchar(45) default '',
  `dish1` tinyint(1) NOT NULL default '0',
  `dish2` tinyint(1) NOT NULL default '0',
  `dish3` tinyint(1) NOT NULL default '0',
  `dish4` tinyint(1) NOT NULL default '0',
  `dish5` tinyint(1) NOT NULL default '0',
  `printed` tinyint(1) NOT NULL default '0',
  `dishgroupid` int(10) unsigned default NULL,
  `statusid` int(11) NOT NULL default '0',
  `createdDate` datetime default NULL,
  `createdBy` varchar(45) default NULL,
  `updatedDate` datetime default NULL,
  `updatedBy` varchar(45) default NULL,
  `dish6` tinyint(1) NOT NULL default '0',
  `dish7` tinyint(1) NOT NULL default '0',
  `dish8` tinyint(1) NOT NULL default '0',
  `dish9` tinyint(1) NOT NULL default '0',
  `dish10` tinyint(1) NOT NULL default '0',
  `tableId` varchar(45) default NULL,
  `todaysid` int(10) unsigned default NULL,
  `orderid` int(10) unsigned default NULL,
  `ticketid` int(10) unsigned default NULL,
  `sycorderid` int(10) unsigned default NULL,
  `status` int(11) NOT NULL default '1',
  PRIMARY KEY  (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 AUTO_INCREMENT=41 ;

CREATE TABLE `viewbuffetpeople` (
  `id` int(10) unsigned NOT NULL auto_increment,
  `customertype` varchar(45) default NULL,
  `quantity` int(10) unsigned default NULL,
  `orderid` int(10) unsigned default NULL,
  `tableId` varchar(45) default NULL,
  `todaysId` int(10) unsigned default NULL,
  `statusid` int(10) unsigned default NULL,
  `ticketid` int(10) unsigned default NULL,
  PRIMARY KEY  (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 AUTO_INCREMENT=111 ;

CREATE TABLE `vipcard` (
  `CardNo` varchar(20) NOT NULL default '',
  `CustomerID` varchar(25) NOT NULL default '0',
  `Rate` smallint(5) NOT NULL default '0',
  `RateEnName` varchar(25) NOT NULL default '',
  `Percentage` double NOT NULL default '0',
  `IssueTime` timestamp NOT NULL default CURRENT_TIMESTAMP,
  `WaiterID` int(10) unsigned NOT NULL default '0',
  `Void` tinyint(1) NOT NULL default '0',
  `RateCnName` varchar(25) NOT NULL default '',
  `ExpireTime` timestamp NOT NULL default '1980-01-01 00:00:00',
  PRIMARY KEY  (`CardNo`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

CREATE TABLE `vipcardpoint` (
  `CardNo` varchar(20) NOT NULL default '',
  `Point` double NOT NULL default '0',
  `PRate` smallint(5) NOT NULL default '0',
  PRIMARY KEY  (`CardNo`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

CREATE TABLE `vipcardpointsetup` (
  `PRate` smallint(5) NOT NULL default '0',
  `PointCent` double NOT NULL default '0',
  PRIMARY KEY  (`PRate`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

CREATE TABLE `vipcardsetup` (
  `Rate` smallint(5) NOT NULL default '0',
  `RateEnName` varchar(25) NOT NULL default '',
  `Percentage` double NOT NULL default '0',
  `RateCnName` varchar(25) NOT NULL default '',
  PRIMARY KEY  (`Rate`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

CREATE TABLE `vipevent` (
  `EventID` int(10) unsigned NOT NULL auto_increment,
  `CustomerID` int(10) unsigned NOT NULL,
  `EventType` int(10) unsigned NOT NULL,
  `EventDate` datetime NOT NULL,
  `EventDesc` varchar(50) default NULL,
  PRIMARY KEY  (`EventID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

CREATE TABLE `vipeventtype` (
  `EventType` int(10) unsigned NOT NULL auto_increment,
  `EventName1` varchar(25) NOT NULL,
  `EventName2` varchar(25) default NULL,
  `EventDesc1` varchar(50) default NULL,
  `EventDesc2` varchar(50) default NULL,
  `EventMemo` varchar(100) default NULL,
  PRIMARY KEY  (`EventType`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 AUTO_INCREMENT=4 ;

CREATE TABLE `vippaymentthreshold` (
  `PRange` smallint(5) NOT NULL default '0',
  `MinValue` smallint(5) NOT NULL default '0',
  `MaxValue` smallint(5) NOT NULL default '0',
  `PointAdd` smallint(5) NOT NULL default '0',
  PRIMARY KEY  (`PRange`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

CREATE TABLE `vippaymenttypesetup` (
  `PType` smallint(5) NOT NULL default '0',
  `PTypeDesc` varchar(50) NOT NULL default '',
  `PTypeEnabled` smallint(5) NOT NULL default '0',
  PRIMARY KEY  (`PType`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

CREATE TABLE `zipmap` (
  `zipcode` varchar(5) NOT NULL default '',
  `cityname` varchar(28) default NULL,
  `charge` double(15,5) default NULL,
  PRIMARY KEY  (`zipcode`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
